<?php
/* --------------------------------------------------------------
  function.product.php 2019-09-30
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

/**
 * @param                          $params
 * @param Smarty_Internal_Template $template
 *
 * @return string
 * @throws Exception
 */
function smarty_function_product_list($params, &$template)
{
    $callback = function ($value) {
        return str_replace("'", '', $value);
    };

    $params = array_map($callback, $params);
    $constructorParams = [
        'categoryId'  => (int)$params['categoryId'],
        'listType'    => $params['listType'],
        'random'      => $params['random'] === 'true',
        'itemsPerRowXs'      => $params['itemsPerRowXs'],
        'itemsPerRowSm'      => $params['itemsPerRowSm'],
        'itemsPerRowMd'      => $params['itemsPerRowMd'],
        'itemsPerRowLg'      => $params['itemsPerRowLg'],
        'maxProducts' => (int)$params['maxProducts'],
        'presentation' => $params['presentation'],
        'id'           => $params['id'],
        'class'        => $params['class'],
    ];
    $constructorParams['languageId'] = (int)$params['languageId'];
    $constructorParams['languageCode'] = MainFactory::create(LanguageCode::class, new StringType((string)$params['languageCode']));

    $configurationFactory = MainFactory::create(ProductListWidgetConfigurationFactory::class);

    $construct = [
        $configurationFactory->createCommandConfigurationFromArray($constructorParams),
        explode(',', $params['products'])
    ];

    $result = MainFactory::create(ProductListWidgetOutputCommand::class, ...$construct)->execute() ?? '';

    if (!$result) {
        $result = '';
    }

    return $result;
}
